----------------
title : C++ 레퍼런스 - istream::tellg 함수
cat_title : istream::tellg
ref_title : tellg, istream::tellg
publish_date : 2019-04-19
path : /C++ Reference/iostream
--------------

##@ cpp-ref-start

#@ istream::tellg

`<istream>` 에 정의됨

```cpp-formatted
pos_type tellg();
```

현재 연관된 `streambuf` 객체의 **입력 위치 지정자(position indicator)** 를 리턴한다.

### 리턴값

현재 `get pointer` 가 가리키고 있는 위치를 리턴한다. 실패 시에 `-1` 을 리턴한다.

### 실행 예제

```cpp-formatted
#include <iostream>
#include <sstream>
#include <string>

int main() {
  std::string str = "Hello, world";
  std::istringstream in(str);
  std::string word;
  in >> word;
  std::cout << "단어 \"" << word
            << "\" 를 읽은 후에 tellg() 의 값은 : " << in.tellg() << '\n';
}
```

```exec
단어 "Hello," 를 읽은 후에 tellg() 의 값은 : 6
```


### 참고 자료

* `seekg` : 입력 위치 지정자를 설정한다.
* `tellp` : 출력 위치 지정자를 리턴한다.
* `seekp` : 출력 위치 지정자를 설정한다.